/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.item;

import java.util.EnumMap;
import java.util.List;
import technology.rocketjump.undermount.assets.entities.item.ItemEntityAssetsByPlacement;
import technology.rocketjump.undermount.assets.entities.item.model.ItemEntityAsset;
import technology.rocketjump.undermount.assets.entities.item.model.ItemSize;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;

public class ItemEntityAssetsBySize {
    private EnumMap<ItemSize, ItemEntityAssetsByPlacement> byItemSize = new EnumMap(ItemSize.class);

    public ItemEntityAssetsBySize() {
        for (ItemSize itemSize : ItemSize.values()) {
            this.byItemSize.put(itemSize, new ItemEntityAssetsByPlacement());
        }
    }

    public void add(ItemEntityAsset asset) {
        ItemSize assetItemSize = asset.getItemSize();
        if (assetItemSize == null) {
            for (ItemSize itemSize : ItemSize.values()) {
                this.byItemSize.get((Object)itemSize).add(asset);
            }
        } else {
            this.byItemSize.get((Object)assetItemSize).add(asset);
        }
    }

    public ItemEntityAsset get(ItemEntityAttributes attributes) {
        ItemSize itemSize = attributes.getItemSize();
        if (itemSize == null) {
            itemSize = ItemSize.AVERAGE;
        }
        return this.byItemSize.get((Object)itemSize).get(attributes);
    }

    public List<ItemEntityAsset> getAll(ItemEntityAttributes attributes) {
        ItemSize itemSize = attributes.getItemSize();
        if (itemSize == null) {
            itemSize = ItemSize.AVERAGE;
        }
        return this.byItemSize.get((Object)itemSize).getAll(attributes);
    }
}

